




/**********************************************************************************************
 *                                                                                            *
 * Ex3.      :   Sent Command Control ON/OFF 7-Segment (RL)                                   *
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 *                                                                                            *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR ATMEGA128 r3 Board)                        *
 *                : X-TAL : 16 MHz                                                            *
 *                                                                                            *
 * Editor         : AVR Studio 4.15 Build 623                                                 *
 * Compiler       : WinAVR-20081205                                                           *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 08/October/2014                                                           *
 *                                                                                            *
 * Port Interface :  --- MCU-AVR Mega 128 ---           --- Module REMOTE DISTANCE ---        *
 *                                                                                            *
 *       Uart0    :  PE0 = RXDO (LineDrive)      Connect      Tx(RS232 Port)                  *  
 *                   PE1 = TXD0 (LineDrive)      Connect      Rx(RS232 Port)                  * 
 *                                                                                            *
 *                                                           Set JP-TTL/RS232 to RS232        *
 *       Baud Rate = 57600 at Clock 16 Mhz                   Set JP-BR (57600)                *
 *                                                           Disable Filter                   *
 *                                                                                            *
 *                                                                                            * 
 *                                                                                            * 
 *   Operation    :  Control 7-Segment on Module ON/OFF Every  2 Sec                          *   
 *                                                                                            *
 **********************************************************************************************/
 

#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/pgmspace.h>            //for progrm data to Area Flash
#include <avr/interrupt.h>           //Interrupt Service routine

#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include<util/delay.h>               //util_delay


 void Check_Echo_Cmm(void) ;

//-------------- Function Delay_ms ------------------

void delay_ms(unsigned int i)
 {
   for(;i>0;i--)
      _delay_ms(1);
 }




/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);




//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
     fputs("*ring*\n",stderr) ;
     return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }



//------------------- Initial UART0 -----------------------

 static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 16        ;     //Set Baud Rate 57600(16) : BURR= [Fosc/[16x(9600)]]-1
  
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter,enable Rx INT.
       
   stdout = &uart_str ;     //Set address uart_str to stdout/stdin

   
 }


     

//-------------- Recive Echo Command ----------------

void Check_Echo_Cmm(void)
 {
   char ch ;
     do
      {
       
        loop_until_bit_is_set(UCSR0A,RXC)        ; //Check data in Rx_buffer
        ch = UDR0                                ; //Read data Start Byte

      }while(ch != '#')                          ; //Check Byte Start of Echo cmm('#')
     
      do
      {
       
        loop_until_bit_is_set(UCSR0A,RXC)        ; //Check data in Rx_buffer
        ch = UDR0                                ; //Read data Start Byte

      }while(ch != 0x0D)                         ; //Check Byte End of Echo cmm(0x0D)
   
 }




/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


 int main (void) 
  {
     unsigned char enter = 0x0D ;
   
  
    delay_ms(500)      ;  //Wait Module ET-Remote Distance Ready when Power On
       

    UART0_Init()       ;  //Initial Uart0 


//----------------- Start Sent Command Control ON/OFF 7-Segment On Module --------------

    while(1) 
    {   
      //################---- Sent Command RL ----#################
	  
	  printf("*RL=%c",enter)                      ;  //Sent Command ON/OFF 7-Segment(Command Control 7-Seg fomat Toggle)   
      Check_Echo_Cmm()                            ;  //Wait Echo Command for Sent Next Command	   
      delay_ms(2000)                              ;  //delay 2 Second


	}//while

  }



